## Example 03 - version 1

set Warehouses;
set Shops;

param cost{i in Warehouses, j in Shops};
param supply{i in Warehouses};
param demand{j in Shops};

var amount{i in Warehouses, j in Shops};

minimize Cost : sum{i in Warehouses, j in Shops}cost[i,j]*amount[i,j];

subject to Supply{i in Warehouses} : sum{j in Shops}amount[i,j]<=supply[i];
subject to Demand{j in Shops} : sum{i in Warehouses}amount[i,j]>=demand[j];
subject to positive{i in Warehouses, j in Shops} : amount[i,j]>=0;
